dofile(LockOn_Options.script_path.."HUD/Indicator/HUD_definitions.lua")

SymbologyBox_sizeX = 90
SymbologyBox_sizeY_min = -215 -- SymbologyBox_sizeX
SymbologyBox_sizeY_max =  167 

SymbologyBox = CreateElement "ceMeshPoly"
SymbologyBox.name = "SymbologyBox"
SymbologyBox.primitivetype = "triangles"

SymbologyBox.vertices	= { {-SymbologyBox_sizeX,SymbologyBox_sizeY_min},
							{-SymbologyBox_sizeX,SymbologyBox_sizeY_max},
							{ SymbologyBox_sizeX,SymbologyBox_sizeY_max},
							 {SymbologyBox_sizeX,SymbologyBox_sizeY_min}
							}

SymbologyBox.indices		 = default_box_indices
SymbologyBox.init_pos		 = {0, 0,  -0.005/GetScale()}
SymbologyBox.init_rot		 = {0, 0, -48.1}
SymbologyBox.material		 = "DBG_GREEN"
SymbologyBox.h_clip_relation = h_clip_relations.REWRITE_LEVEL
SymbologyBox.level			 = HUD_NOCLIP_LEVEL
SymbologyBox.isdraw			 = true
SymbologyBox.change_opacity	 = false
SymbologyBox.isvisible		 = false
Add(SymbologyBox)

total_field_of_view = CreateElement "ceMeshPoly"
total_field_of_view.name = "total_field_of_view"
total_field_of_view.primitivetype = "triangles"

num_points = 32
step = math.rad(360.0/num_points)

verts = {}
for i = 1, num_points do
	verts[i] = {TFOV * math.cos(i * step), TFOV * math.sin(i * step)}
end

total_field_of_view.vertices = verts

inds = {}
j = 0
for i = 0, 29 do
	j = j + 1
	inds[j] = 0
	j = j + 1
	inds[j] = i + 1
	j = j + 1
	inds[j] = i + 2
end

total_field_of_view.indices			= inds
total_field_of_view.init_pos		= {0, 0, 0}
total_field_of_view.material		= "DBG_RED"
total_field_of_view.h_clip_relation = h_clip_relations.INCREASE_IF_LEVEL
total_field_of_view.level			= HUD_DEFAULT_LEVEL - 1
total_field_of_view.isdraw			= true
total_field_of_view.change_opacity	= false
total_field_of_view.collimated 		= true
total_field_of_view.isvisible		= false
Add(total_field_of_view)


--Ln1 = addHWLine("Ln1", 250, 250, nil, {-150.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, nil, HUD_DEFAULT_LEVEL)
--Ln1.isdraw = true;

DrawRefLines = false

if DrawRefLines then
	ZSL_ref = addHWLine("ZeroLine", 40, 40, {--[[{"ZeroLine"}--]]}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, nil, nil)
	ZSL_ref.h_clip_relation = h_clip_relations.NULL;
	ZSL_ref.isdraw = true;

	ZSL_text = AddHUDTextElement_Pos_Val("ZSL_text", 
					{{"ZeroLine"}}, 
					{45, 0.0, 0.0}, 
					nil,
					HUD_DEFAULT_LEVEL,
					"LeftCenter",
					"ZSL")	
	ZSL_text.h_clip_relation = h_clip_relations.NULL

	GBL_ref = addHWLine("GunLine", 40, 40, {--[[{"GunLine"}--]]}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, nil, nil)
	GBL_ref.h_clip_relation = h_clip_relations.NULL;
	GBL_ref.isdraw = true;

	GBL_text = AddHUDTextElement_Pos_Val("GBL_text", 
					{--[[{"GunLine"}--]]},
					{45, 0.0, 0.0}, 
					nil,
					nil,--HUD_DEFAULT_LEVEL,
					"LeftCenter",
					"GBL")
	GBL_text.h_clip_relation = h_clip_relations.NULL
end

--------------------------------------------------------------------------------

flag_draw_refgrid = false

-- reference grid
if flag_draw_refgrid then
	size = 1.0
	delta = 0.010
	sizeK = 200
	for i = 1,17 do
	
	
		local elv = CreateElement "ceMeshPoly"
		elv.name       = "elv" .. string.format("%i", i)
		elv.primitivetype = "lines"
		elv.vertices   = {{-0.5 * sizeK, 0.0}, {0.5 * sizeK, 0.0}}
		elv.indices    = {0, 1}
		elv.init_pos   = {0.0, 0.0, 0}
		elv.material   = "INDICATION_COMMON_GREEN"
		elv.controllers = {{"dbg_linegrid", 0,  delta * (i-1)}}
		elv.collimated = true
		Add(elv)
		
		local elv2 = Copy(elv)
		elv2.controllers = {{"dbg_linegrid", 0,-delta * (i-1)}}
		Add(elv2)
	end
	for i = 1,17 do
	local elg = CreateElement "ceMeshPoly"
		elg.name       = "elg" .. string.format("%i", i)
		elg.primitivetype = "lines"
		elg.vertices   = {{0.0,-0.5 * sizeK}, {0.0,0.5 * sizeK}}
		elg.indices    = {0, 1}
		elg.init_pos   = {0.0, 0.0, 0}
		elg.material   = "INDICATION_COMMON_GREEN"	
		elg.controllers = {{"dbg_linegrid",delta * (i-1),0}}
		elg.collimated = true
		Add(elg)
		
		local elg2 = Copy(elg)
		elg2.controllers = {{"dbg_linegrid",-delta * (i-1),0}}
		Add(elg2)
	end
	local circle170 = CreateElement "ceMeshPoly"
		circle170.name       =  create_guid_string()
		circle170.primitivetype = "triangles"
		set_circle(circle170,170,169)
		circle170.material   = "INDICATION_COMMON_GREEN"
		circle170collimated = true
		Add(circle170)
end

if _DEBUG_ then

local 	dbg_solution 		   		= CreateElement "ceMeshPoly"
		dbg_solution.name       	= "dbg_solution"
		dbg_solution.primitivetype  = "triangles"
		dbg_solution.vertices   	= {{-2, 2},
									   { 2, 2},
									   { 2,-2},
									   {-2,-2},
									   }
		dbg_solution.indices    	= default_box_indices
		dbg_solution.material   	= "INDICATION_COMMON_RED"
		dbg_solution.controllers	= {{"dbg_solution_point"}}
		dbg_solution.collimated 	= true
		dbg_solution.additive_alpha = true
		Add(dbg_solution)

local 	dbg_SPI		   			= CreateElement "ceMeshPoly"
		dbg_SPI.name       		= "dbg_SPI"
		dbg_SPI.primitivetype   = "triangles"
		dbg_SPI.vertices   		= {{-2, 2},
								   { 2, 2},
								   { 2,-2},
								   {-2,-2},
								   }
		dbg_SPI.indices    	= default_box_indices
		dbg_SPI.material   	= "INDICATION_COMMON_BLUE"
		dbg_SPI.controllers	= {{"dbg_spi_point"}}
		dbg_SPI.collimated 	= true
		dbg_SPI.additive_alpha = true
		Add(dbg_SPI)
		
end